<?php
namespace VM\ApiBundle\Security\WebService;

use Symfony\Component\Security\Core\Encoder\PasswordEncoderInterface;

/**
 * Class encode password
 *
 * If user is from Nowa Era the salt is empty and password verification is done by API,
 * so this function always set true
 *
 * For other users the salt isn't empty so the password is encoded
 *
 */
class PasswordEncoder implements PasswordEncoderInterface
{

    public function encodePassword($raw, $salt)
    {
        if(empty($salt))
        {
            return '';
        }
        else
        {
            return hash('sha512', $salt . $raw); // Custom function for encrypt
        }
    }

    public function isPasswordValid($encoded, $raw, $salt)
    {
        return true;
    }


    public function generatePassword($string = null)
    {
        $date = new \DateTime();
        $hash = hash('sha512', $date->format("YmdHis") . $string);
        $passLength = rand(8, 16);
        $startPosition = rand(1, strlen($hash) - $passLength);
        return substr($hash, $startPosition, $passLength);
    }


    public function generateSalt($string = null)
    {
        $date = new \DateTime();
        $hash = hash('sha256', $date->format("YmdHis") . $string);
        return substr($hash, 0, 30);
    }

}